package gov.va.vamf.scheduling.varutility.resources;

import gov.va.vamf.scheduling.varutility.domain.Institution;
import gov.va.vamf.scheduling.varutility.clientapi.MobileHealthClientTestVersion;
import gov.va.vamf.scheduling.varutility.testutility.TestHelper;
import gov.va.vamf.scheduling.varutility.testutility.IntegrationTestConfiguration;

import org.junit.*;

import javax.ws.rs.client.Client;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

import java.net.URI;
import java.util.List;

public class VarUtilityInstitutionTest {
    private static MobileHealthClientTestVersion client;
    private static Client jerseyClient;
    private static final String SITE_CODE = "523";

    @BeforeClass
    public static void startup() {
        client = TestHelper.createProviderClient();
        jerseyClient = client.getJerseyClient();
    }

    @AfterClass
    public static void destroy() {
        if (client != null) {
            client.getJerseyClient().close();
            client = null;
        }
    }

    @Test
    public void testFetchInstitutions() {
        List<Institution> findInstitutions = jerseyClient.target(getInstitutionsResourceUri(SITE_CODE))
                .request()
                .accept(MediaType.APPLICATION_JSON)
                .get(new GenericType<List<Institution>>(){});

        Assert.assertNotNull(findInstitutions);
        Assert.assertTrue(findInstitutions.size() > 0);
    }

    private static URI getInstitutionsResourceUri(String siteCode) {
        String uriFormat = String.format("%s/institutions/site/%s",
                IntegrationTestConfiguration.getServerBaseUri(), siteCode);

        return UriBuilder.fromUri(uriFormat).build();
    }

}

